# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Dynamic to rescue.
# Approach
<!-- Describe your approach to solving the problem. -->
- Broken into simpler 
- gp[t][din] will store minimum difficulty to complete first 't' tasks in 'din' days
---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)
# Complexity
- Time complexity : $$O(l^2d)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(ld)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->
$$l$$ : length of jobDifficulty

# Code
```
class Solution {
    public int minDifficulty(int[] jobDifficulty, int d) {
        if( jobDifficulty.length < d){
            return -1;
        }
        int[][] gp = new int[jobDifficulty.length+1][d+1];
        // gp[t][din] will store minimum difficulty to complete first 't' tasks in 'din' days
        Arrays.stream(gp).forEach(r -> Arrays.fill(r, Integer.MAX_VALUE/3));
	    gp[0][0] = 0;

        for( int i = 1; i <= jobDifficulty.length; i++){
            for( int j = 1; j <= d; j++){
                int m = 0;
                for( int k = i - 1; k >= j - 1; k--){
                    m = Math.max( m, jobDifficulty[k] );
                    gp[i][j] = Math.min( gp[i][j], gp[k][j-1] + m);
                }
            }
        }
        return gp[jobDifficulty.length][d];
    }
}
```